/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.utility.collections;

import java.util.concurrent.TimeUnit;
import net.impactdev.impactor.core.utility.future.CaffeineFactory;
import net.impactdev.impactor.relocations.com.github.benmanes.caffeine.cache.Cache;

public final class ExpiringSet<E> {
    private final Cache<E, Long> cache;
    private final long lifetime;

    public ExpiringSet(long duration, TimeUnit unit) {
        this.cache = CaffeineFactory.newBuilder().expireAfterWrite(duration, unit).build();
        this.lifetime = unit.toMillis(duration);
    }

    public boolean add(E item) {
        boolean present = this.contains(item);
        this.cache.put(item, System.currentTimeMillis() + this.lifetime);
        return !present;
    }

    public boolean contains(E item) {
        Long timeout2 = this.cache.getIfPresent(item);
        return timeout2 != null && timeout2 > System.currentTimeMillis();
    }

    public void remove(E item) {
        this.cache.invalidate(item);
    }
}

